//  convert -resize 320x240 01040043.JPG 133.bmp to convert your file to bmp

/* Connections
ILI9341
-------
VCC,LED = 3.3 Volt
Gnd = Gnd
CS = D4
RST= D2
DC = D15
MOSI = D23 
MISO = D19
SCK  = D18

SD Card
-------
VCC = 3.3 Volt
Gnd = Gnd
CS  = D13
MOSI = D23 
MISO = D19
SCK  = D18

DS3231
------
Vcc = 3.3 Volt
Gnd = Gnd
SDA = D21
SCL = D22

-------

Color combinations

BLACK       0x0000      
NAVY        0x000F      
DARKGREEN   0x03E0      
DARKCYAN    0x03EF      
MAROON      0x7800      
PURPLE      0x780F      
OLIVE       0x7BE0      
LIGHTGREY   0xC618     
DARKGREY    0x7BEF      
BLUE        0x001F      
GREEN       0x07E0     
CYAN        0x07FF     
RED         0xF800     
MAGENTA     0xF81F      
YELLOW      0xFFE0      
WHITE       0xFFFF     
ORANGE      0xFD20      
GREENYELLOW 0xAFE5      
PINK        0xF81F

*/


#include <SD.h>
#include <SPI.h>

#include <Adafruit_GFX.h>    // Core graphics library
#include "Adafruit_ILI9341.h" // Hardware-specific library

#include <Wire.h> // must be included here so that Arduino library object file references work
#include <RtcDS3231.h>
RtcDS3231<TwoWire> Rtc(Wire);
#define countof(a) (sizeof(a) / sizeof(a[0]))


Adafruit_ILI9341 tft = Adafruit_ILI9341(4,15,2);  //(cs,rst,dc)

#define SD_CS 13
boolean SDInited = true;
char fl[7];


uint16_t ccenterx,ccentery;//center x,y of the clock
const uint16_t cradius = 63;//radius of the clock
const float scosConst = 0.0174532925;
float sx = 0, sy = 1, mx = 1, my = 0, hx = -1, hy = 0;
float sdeg=0, mdeg=0, hdeg=0;
uint16_t osx,osy,omx,omy,ohx,ohy;
uint16_t x0 = 0, x1 = 0, yy0 = 0, yy1 = 0;
uint32_t targetTime = 0;// for next 1 second timeout
uint8_t hh,mm,ss;  //containers for current time
char datadate[16];


String dow[7]  = {"Sun","Mon","Tue","Wed","Thu","Fri","Sat"};  // Sunday is dayOfWeek 0
String moy[12] = {"Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"}; // January is month 0

int freq = 2000;
int channel = 0;
int resolution = 8;

void setup(void) {
  Serial.begin(115200);
  tft.begin();
  tft.setCursor(0, 0);
  tft.setTextColor(ILI9341_RED);    
  tft.setTextSize(2);
//  tft.println("BMP Loading!");
  tft.setRotation(3);  
  yield();

  Serial.print("Initializing SD card...");
  if (!SD.begin(SD_CS)) {
    Serial.println("failed!");
    tft.setCursor(0,0);
    tft.print("sd failed!");
    SDInited = false;
    esp_restart();   //Restart again if the SDCard fails to load first time
  }
  Serial.println("OK!");
  delay(2000);
  Rtc.Begin();
    RtcDateTime compiled = RtcDateTime(__DATE__, __TIME__);
//    printDateTime(compiled);
    Serial.println();

    if (!Rtc.IsDateTimeValid()) {
        // Common Cuases:
        //    1) first time you ran and the device wasn't running yet
        //    2) the battery on the device is low or even missing
        Serial.println("RTC lost confidence in the DateTime!");
        // following line sets the RTC to the date & time this sketch was compiled
        // it will also reset the valid flag internally unless the Rtc device is
        // having an issue
        Rtc.SetDateTime(compiled);
    }

    if (!Rtc.GetIsRunning())  {
        Serial.println("RTC was not actively running,  now");
        Rtc.SetIsRunning(true);   //starting
    }
    RtcDateTime now = Rtc.GetDateTime();
    if (now < compiled)     {
        Serial.println("RTC is older than compile time!  (Updating DateTime)");
        Rtc.SetDateTime(compiled);
    }
    else if (now > compiled) {
        Serial.println("RTC is newer than compile time. (this is expected)");
    }
    else if (now == compiled) {
        Serial.println("RTC is the same as compile time! (not expected but all is fine)");
    }

    // never assume the Rtc was last configured by you, so
    // just clear them to your needed state
    Rtc.Enable32kHzPin(false);
    Rtc.SetSquareWavePin(DS3231SquareWavePin_ModeNone); 

  ccenterx = 268;
  ccentery = 189;
  osx = ccenterx;
  osy = ccentery;
  omx = ccenterx;
  omy = ccentery;
  ohx = ccenterx;
  ohy = ccentery;

  ledcSetup(channel, freq, resolution);
  ledcAttachPin(14, channel);
}


void loop() {
RtcDateTime now = Rtc.GetDateTime();  
tft.setCursor(0,0);
tft.setTextColor(0x07FF,0x0000);
int th = now.Hour();
int tm = now.Minute();
int ts = now.Second();
//Arrange the sequences
if(tm==5 and ts==0)  bmpDraw("/pic12.bmp", 0,0);   
if(tm==10 and ts==0) bmpDraw("/pic2.bmp", 0,0);   
if(tm==15 and ts==0) bmpDraw("/pic3.bmp", 0,0);     
if(tm==20 and ts==0) bmpDraw("/pic4.bmp", 0,0);     
if(tm==25 and ts==0) bmpDraw("/pic5.bmp", 0,0); 
if(tm==30 and ts==0) bmpDraw("/pic6.bmp", 0,0);    
if(tm==35 and ts==0) bmpDraw("/pic7.bmp", 0,0);   
if(tm==40 and ts==0) bmpDraw("/pic1.bmp", 0,0);   
if(tm==45 and ts==0) bmpDraw("/pic9.bmp", 0,0);   
if(tm==50 and ts==0) bmpDraw("/pic10.bmp", 0,0);   
if(tm==55 and ts==0) bmpDraw("/pic14.bmp", 0,0);   
if(tm==0  and ts==0) bmpDraw("/pic13.bmp", 0,0);     

//Quarterly alarm generation
 if( th>=5 && th<24)   
  if( (tm==00 || tm==15 || tm==45 || tm==30 ) && (ts==00) ) {
  soundg();
  }  

  drawClockFace();// Draw clock face
  drawClockHands(now.Hour(),now.Minute(),now.Second());

 RtcTemperature temp = Rtc.GetTemperature();
 tft.setCursor(260,165);
 tft.setTextSize(1/2);    //Half size fonts to display
 tft.setTextColor(0x07FF,0x0000);
 tft.print(dow[now.DayOfWeek()]);
 tft.setCursor(243,175);
 printDigits(now.Day());
 tft.print("/");
 printDigits(now.Month());
 tft.print("/");
 printDigits(now.Year()-2000);


 tft.setTextColor(0xF81F,0x0000);
 tft.setCursor(260,210);
 tft.print(temp.AsFloat());
 tft.print("c");
 delay(1000);
}




#define BUFFPIXEL 20  //20

void bmpDraw(char *filename, int16_t x, int16_t y) {

  File     bmpFile;
  int      bmpWidth, bmpHeight;   // W+H in pixels
  uint8_t  bmpDepth;              // Bit depth (currently must be 24)
  uint32_t bmpImageoffset;        // Start of image data in file
  uint32_t rowSize;               // Not always = bmpWidth; may have padding
  uint8_t  sdbuffer[3*BUFFPIXEL]; // pixel buffer (R+G+B per pixel)
  uint8_t  buffidx = sizeof(sdbuffer); // Current position in sdbuffer
  boolean  goodBmp = false;       // Set to true on valid header parse
  boolean  flip    = true;        // BMP is stored bottom-to-top
  int      w, h, row, col, x2, y2, bx1, by1;
  uint8_t  r, g, b;
  uint32_t pos = 0, startTime = millis();

  if((x >= tft.width()) || (y >= tft.height())) return;

  Serial.println();
  Serial.print(F("Loading image '"));
  Serial.print(filename);
  Serial.println('\'');

  // Open requested file on SD card
  if ((bmpFile = SD.open(filename)) == NULL) {
    Serial.print(F("File not found"));
    return;
  }

  // Parse BMP header
  if(read16(bmpFile) == 0x4D42) { // BMP signature
    Serial.print(F("File size: ")); Serial.println(read32(bmpFile));
    (void)read32(bmpFile); // Read & ignore creator bytes
    bmpImageoffset = read32(bmpFile); // Start of image data
    Serial.print(F("Image Offset: ")); Serial.println(bmpImageoffset, DEC);
    // Read DIB header
    Serial.print(F("Header size: ")); Serial.println(read32(bmpFile));
    bmpWidth  = read32(bmpFile);
    bmpHeight = read32(bmpFile);
    if(read16(bmpFile) == 1) { // # planes -- must be '1'
      bmpDepth = read16(bmpFile); // bits per pixel
      Serial.print(F("Bit Depth: ")); Serial.println(bmpDepth);
      if((bmpDepth == 24) && (read32(bmpFile) == 0)) { // 0 = uncompressed

        goodBmp = true; // Supported BMP format -- proceed!
        Serial.print(F("Image size: "));
        Serial.print(bmpWidth);
        Serial.print('x');
        Serial.println(bmpHeight);

        // BMP rows are padded (if needed) to 4-byte boundary
        rowSize = (bmpWidth * 3 + 3) & ~3;

        // If bmpHeight is negative, image is in top-down order.
        // This is not canon but has been observed in the wild.
        if(bmpHeight < 0) {
          bmpHeight = -bmpHeight;
          flip      = false;
        }

        // Crop area to be loaded
        x2 = x + bmpWidth  - 1; // Lower-right corner
        y2 = y + bmpHeight - 1;
        if((x2 >= 0) && (y2 >= 0)) { // On screen?
          w = bmpWidth; // Width/height of section to load/display
          h = bmpHeight;
          bx1 = by1 = 0; // UL coordinate in BMP file
          if(x < 0) { // Clip left
            bx1 = -x;
            x   = 0;
            w   = x2 + 1;
          }
          if(y < 0) { // Clip top
            by1 = -y;
            y   = 0;
            h   = y2 + 1;
          }
          if(x2 >= tft.width())  w = tft.width()  - x; // Clip right
          if(y2 >= tft.height()) h = tft.height() - y; // Clip bottom
  
          // Set TFT address window to clipped image bounds
          tft.startWrite(); // Requires start/end transaction now
          tft.setAddrWindow(x, y, w, h);
  
          for (row=0; row<h; row++) { // For each scanline...
  
            // Seek to start of scan line.  It might seem labor-
            // intensive to be doing this on every line, but this
            // method covers a lot of gritty details like cropping
            // and scanline padding.  Also, the seek only takes
            // place if the file position actually needs to change
            // (avoids a lot of cluster math in SD library).
            if(flip) // Bitmap is stored bottom-to-top order (normal BMP)
              pos = bmpImageoffset + (bmpHeight - 1 - (row + by1)) * rowSize;
            else     // Bitmap is stored top-to-bottom
              pos = bmpImageoffset + (row + by1) * rowSize;
            pos += bx1 * 3; // Factor in starting column (bx1)
            if(bmpFile.position() != pos) { // Need seek?
              tft.endWrite(); // End TFT transaction
              bmpFile.seek(pos);
              buffidx = sizeof(sdbuffer); // Force buffer reload
              tft.startWrite(); // Start new TFT transaction
            }
            for (col=0; col<w; col++) { // For each pixel...
              // Time to read more pixel data?
              if (buffidx >= sizeof(sdbuffer)) { // Indeed
                tft.endWrite(); // End TFT transaction
                bmpFile.read(sdbuffer, sizeof(sdbuffer));
                buffidx = 0; // Set index to beginning
                tft.startWrite(); // Start new TFT transaction
              }
              // Convert pixel from BMP to TFT format, push to display
              b = sdbuffer[buffidx++];
              g = sdbuffer[buffidx++];
              r = sdbuffer[buffidx++];
              tft.writePixel(tft.color565(r,g,b));
            } // end pixel
          } // end scanline
          tft.endWrite(); // End last TFT transaction
        } // end onscreen
        Serial.print(F("Loaded in "));
        Serial.print(millis() - startTime);
        Serial.println(" ms");
      } // end goodBmp
    }
  }

  bmpFile.close();
  if(!goodBmp) {
  Serial.println(F("BMP format not recognized."));
       tft.setCursor(0,0);
      tft.print("file unrecognized!");

  }

}
// These read 16- and 32-bit types from the SD card file.
// BMP data is stored little-endian, Arduino is little-endian too.
// May need to reverse subscript order if porting elsewhere.

uint16_t read16(File &f) {
  uint16_t result;
  ((uint8_t *)&result)[0] = f.read(); // LSB
  ((uint8_t *)&result)[1] = f.read(); // MSB
  return result;
}

uint32_t read32(File &f) {
  uint32_t result;
  ((uint8_t *)&result)[0] = f.read(); // LSB
  ((uint8_t *)&result)[1] = f.read();
  ((uint8_t *)&result)[2] = f.read();
  ((uint8_t *)&result)[3] = f.read(); // MSB
  return result;
}

void printDateTime(const RtcDateTime& dt){
    char datestring[20];
    RtcTemperature temp = Rtc.GetTemperature();
    snprintf_P(datestring, 
            countof(datestring),
            PSTR("%02u/%02u/%04u %02u:%02u:%02u"),
            dt.Day(),
            dt.Month(),
            dt.Year(),
            dt.Hour(),
            dt.Minute(),
            dt.Second() );
    Serial.println(datestring);
}


void drawClockHands(uint8_t h,uint8_t m,uint8_t s){
  // Pre-compute hand degrees, x & y coords for a fast screen update
  sdeg = s * 6;                  // 0-59 -> 0-354
  mdeg = m * 6 + sdeg * 0.01666667;  // 0-59 -> 0-360 - includes seconds
  hdeg = h * 30 + mdeg * 0.0833333;  // 0-11 -> 0-360 - includes minutes and seconds
  hx = cos((hdeg-90)*scosConst);    
  hy = sin((hdeg-90)*scosConst);
  mx = cos((mdeg-90)*scosConst);    
  my = sin((mdeg-90)*scosConst);
  sx = cos((sdeg-90)*scosConst);    
  sy = sin((sdeg-90)*scosConst);

  // Erase just old hand positions
  tft.drawLine(ohx, ohy, ccenterx+1, ccentery+1, 0x0000);  
  tft.drawLine(omx, omy, ccenterx+1, ccentery+1, 0x0000);  
  tft.drawLine(osx, osy, ccenterx+1, ccentery+1, 0x0000);
  // Draw new hand positions  
  tft.drawLine(hx*(cradius-28)+ccenterx+1, hy*(cradius-28)+ccentery+1, ccenterx+1, ccentery+1, 0x07E0);  //green
  tft.drawLine(mx*(cradius-17)+ccenterx+1, my*(cradius-17)+ccentery+1, ccenterx+1, ccentery+1, 0xFFFF); //white
  tft.drawLine(sx*(cradius-14)+ccenterx+1, sy*(cradius-14)+ccentery+1, ccenterx+1, ccentery+1, 0xF800);//red
  tft.fillCircle(ccenterx+1, ccentery+1, 3, 0xF800);

  // Update old x&y coords
  osx = sx*(cradius-14)+ccenterx+1;
  osy = sy*(cradius-14)+ccentery+1;
  omx = mx*(cradius-17)+ccenterx+1;
  omy = my*(cradius-17)+ccentery+1;
  ohx = hx*(cradius-28)+ccenterx+1;
  ohy = hy*(cradius-28)+ccentery+1;
}


void drawClockFace(){
//  cradius = cradius - 20;
  tft.fillCircle(ccenterx, ccentery, cradius-10, 0x001F);  //blue
  tft.fillCircle(ccenterx, ccentery, cradius-4-10, 0x0000); //black
  // Draw 12 lines
  for(int i = 0; i<360; i+= 30) {
    sx = cos((i-90)*scosConst);
    sy = sin((i-90)*scosConst);
    x0 = sx*(cradius-4-10)+ccenterx;
    yy0 = sy*(cradius-4-10)+ccentery;
    x1 = sx*(cradius-11-10)+ccenterx;
    yy1 = sy*(cradius-11-10)+ccentery;
    tft.drawLine(x0, yy0, x1, yy1,  0x07FF);  //blue
  }
}

void printDigits(int digits){
  if(digits < 10)
    tft.print('0');
    tft.print(digits);
}


void soundg() {
ledcWriteTone(channel, 2000);
ledcWrite(channel, 125);
for (int freq = 255; freq < 1500; freq = freq + 250){
//     Serial.println(freq);
     ledcWriteTone(channel, freq);
     delay(300);
}
freq=0;
ledcWriteTone(channel, freq);
//delay(5000); 
}

